﻿using Percent___Qualification_work.Classes;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.UI.Design;
using System.Windows.Forms;

namespace Percent___Qualification_work.Forms
{
    public partial class MovieDetailsDialog : Form
    {
        private DataRow movie;
        private bool isConfirmingScore = false;
        public event Action RefreshMovies;
        public MovieDetailsDialog(DataRow movie)
        {
            InitializeComponent();
            this.movie = movie;
            LoadMovieDetails();
        }

        private void LoadMovieDetails()
        {
            movieName.Text = movie["MovieName"].ToString();
            movieDirector.Text = movie["Director"].ToString();
            movieGenre.Text = movie["Genre"].ToString();
            movieYear.Text = movie["ReleaseYear"].ToString();
            score.Text = movie["UserScore"].ToString();
            if (movie["CoverImage"] is byte[] imageData)
            {
                pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
                pictureBox1.Image = ConvertBytesToImage(imageData);
            }
        }
        private Image ConvertBytesToImage(byte[] imageData)
        {
            using (var ms = new System.IO.MemoryStream(imageData))
            {
                return Image.FromStream(ms);
            }
        }

        private void changeScoreBtn_Click(object sender, EventArgs e)
        {
            if (isConfirmingScore == false)
            {
                scoreBar.Visible = true;
                scoreLabel1.Visible = true;
                scoreLabel10.Visible = true;
                scoreBar.Value = Convert.ToInt32(movie["UserScore"]);
                changeScoreBtn.Text = "Confirm";
                isConfirmingScore = true;
            }
            else
            {
                DatabaseConnection.Instance.ChangeMovieScore(Convert.ToInt32(movie["MovieId"]), scoreBar.Value);
                MessageBox.Show("The score has been updated, please re-open this window to see changes!");
                isConfirmingScore = false;
                RefreshMovies?.Invoke();
                changeScoreBtn.Text = "Change score";
                scoreBar.Visible = false;
                scoreLabel1.Visible = false;
                scoreLabel10.Visible = false;
            }
        }

        private void deleteBtn_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("Are you sure you want to delete this movie from your list?", "Confirm delete", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (result == DialogResult.Yes)
            {
                DatabaseConnection.Instance.DeleteMovie(Convert.ToInt32(movie["MovieId"]));
                MessageBox.Show("Game successfully deleted.");
                RefreshMovies?.Invoke();
                this.Close();
            }
        }
    }
}
